#Load SWIS Snapin 
if (!(Get-PSSnapin | where {$_.Name -eq "SwisSnapin"})) 
{ 
Add-PSSnapin "SwisSnapin" 
}
#Connection SW, please SW server and credentials
$hostname = "localhost" 
$username = "admin" 
$password = "password" 
$cred = New-Object -typename System.Management.Automation.PSCredential -argumentlist @($username,(ConvertTo-SecureString -String $password -AsPlainText -Force)) 
$swis= Connect-Swis -Credential $cred -Hostname $hostname 

#Get incompatible custom pollers
$uris = get-swisdata $swis -query "SELECT cpan.uri FROM Orion.NPM.CustomPollerAssignmentOnNode cpan where cpan.custompoller.uniquename is not null
and cpan.CustomPollerAssignmentID not in ( SELECT CustomPollerAssignmentID FROM Orion.NPM.CustomPollerStatus ) and cpan.nodeid not IN
( SELECT n.nodeid FROM orion.NODES N WHERE n.ObjectSubType<>'ICMP' AND minutediFF(n.LastSystemUptimePollUtc, GETUTCDATE())>(n.Statcollection*3)
AND n.STATUS NOT IN (2,9))"

#Delete incompatible custom pollers
foreach ($uri in $uris)
{
remove-swisobject $swis -uri $uri
} 
